<?php

namespace Drupal\Tests\image_effects\Unit;

use Drupal\image_effects\Component\MatrixUtility;
use PHPUnit\Framework\TestCase;

/**
 * Tests the matrix utility helper methods.
 *
 * @coversDefaultClass \Drupal\image_effects\Component\MatrixUtility
 *
 * @group image_effects
 */
class MatrixUtilityTest extends TestCase {

  /**
   * Data provider for testCumulativeSum.
   */
  public function cumulativeSumProvider() {
    return [
      'https://stackoverflow.com/questions/39937212/maximum-subarray-of-size-hxw-within-a-2d-matrix' => [
        [
          [2, 4, 5, 6],
          [2, 3, 1, 4],
          [2, 0, 2, 1],
        ],
        [
          [2, 6, 11, 17],
          [4, 11, 17, 27],
          [6, 13, 21, 32],
        ],
      ],
      // @codingStandardsIgnoreStart
      'Balloons 800x600 image, 5x5 grid, 3x3 window, iteration 0' => [
        [
          [7.149828007969111, 7.377109914501309, 6.200195237597156, 6.21529241148999, 6.205804575304279],
          [7.1626254196088635, 7.40665458253523, 7.491869219375936, 7.2933389056920195, 6.395786196023001],
          [6.6233136805241095, 6.670662585346542, 7.081050874011568, 7.10709060310774, 6.834168028092206],
          [6.840680604737137, 7.317940070530257, 7.44798661505297, 7.464103974798621, 7.00017233705262],
          [6.8375168995296605, 6.36790072363858, 5.72258314500562, 6.012755568956032, 7.834271994405132],
        ],
        [
          [7.149828007969111, 14.52693792247042, 20.727133160067577, 26.942425571557568, 33.14823014686185],
          [14.312453427577974, 29.096217924614514, 42.7882823815876, 56.29691369876961, 68.8985044700969],
          [20.935767108102084, 42.39019419048517, 63.16330952146982, 83.77903144175957, 103.21479024117907],
          [27.77644771283922, 56.54881486575256, 84.76991681179018, 112.84974270687856, 139.28567384335068],
          [34.61396461236888, 69.7542324889208, 103.69791757996403, 137.79049904400844, 172.0607021748857],
        ],
      ],
      'Balloons 800x600 image, 5x5 grid, 3x3 window, iteration 1' => [
        [
          [7.395436748720447, 5.66611215154807, 6.69812517537742, 7.550435693680547, 5.6395071065155],
          [7.104492594697432, 5.483458489320918, 7.297321630001654, 7.3444158201449, 6.417652603273953],
          [6.107467467659251, 6.335352488140159, 5.822234213213471, 7.268959560644678, 6.539889551693768],
          [6.368403195659311, 6.317856772517688, 5.975990939186924, 5.51054232849404, 5.471596350629088],
          [7.182472403557108, 7.492456362078498, 7.505260890654098, 7.695289087744044, 7.787432426833892],
        ],
        [
          [7.395436748720447, 13.061548900268516, 19.759674075645936, 27.310109769326484, 32.94961687584198],
          [14.499929343417879, 25.649499984286866, 39.644946789665944, 54.539798303491395, 66.59695801328084],
          [20.60739681107713, 38.09231994008628, 57.91000095867883, 80.07381203314895, 98.67086129463216],
          [26.975800006736442, 50.778579908263275, 76.57225186604275, 104.24660526900689, 128.31525088111917],
          [34.15827241029355, 65.45350867389887, 98.75244152233243, 134.1220840130406, 165.9781620519868],
        ],
      ],
      // @codingStandardsIgnoreEnd
    ];
  }

  /**
   * @covers ::cumulativeSum
   * @dataProvider cumulativeSumProvider
   */
  public function testCumulativeSum($input, $expected) {
    $this->assertSame($expected, MatrixUtility::cumulativeSum($input));
  }

  /**
   * Data provider for testFindMaxSumSubmatrix.
   */
  public function findMaxSumSubmatrixProvider() {
    return [
      'https://stackoverflow.com/questions/39937212/maximum-subarray-of-size-hxw-within-a-2d-matrix' => [
        [
          [2, 6, 11, 17],
          [4, 11, 17, 27],
          [6, 13, 21, 32],
        ],
        2,
        2,
        [0, 2, 16],
      ],
      // @codingStandardsIgnoreStart
      'Balloons 800x600 image, 5x5 grid, 3x3 window, iteration 0' => [
        [
          [7.149828007969111, 14.52693792247042, 20.727133160067577, 26.942425571557568, 33.14823014686185],
          [14.312453427577974, 29.096217924614514, 42.7882823815876, 56.29691369876961, 68.8985044700969],
          [20.935767108102084, 42.39019419048517, 63.16330952146982, 83.77903144175957, 103.21479024117907],
          [27.77644771283922, 56.54881486575256, 84.76991681179018, 112.84974270687856, 139.28567384335068],
          [34.61396461236888, 69.7542324889208, 103.69791757996403, 137.79049904400844, 172.0607021748857],
        ],
        3,
        3,
        [1, 1, 65.28069743045089],
      ],
      'Balloons 800x600 image, 5x5 grid, 3x3 window, iteration 1' => [
        [
          [7.395436748720447, 13.061548900268516, 19.759674075645936, 27.310109769326484, 32.94961687584198],
          [14.499929343417879, 25.649499984286866, 39.644946789665944, 54.539798303491395, 66.59695801328084],
          [20.60739681107713, 38.09231994008628, 57.91000095867883, 80.07381203314895, 98.67086129463216],
          [26.975800006736442, 50.778579908263275, 76.57225186604275, 104.24660526900689, 128.31525088111917],
          [34.15827241029355, 65.45350867389887, 98.75244152233243, 134.1220840130406, 165.9781620519868],
        ],
        3,
        3,
        [0, 2, 60.578541354545884],
      ],
      // @codingStandardsIgnoreEnd
    ];
  }

  /**
   * @covers ::findMaxSumSubmatrix
   * @dataProvider findMaxSumSubmatrixProvider
   */
  public function testFindMaxSumSubmatrix($input, $rows, $columns, $expected) {
    $this->assertSame($expected, MatrixUtility::findMaxSumSubmatrix($input, $rows, $columns));
  }

}
