// Passive event listeners
jQuery.event.special.touchstart = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchstart", handle, { passive: !ns.includes("noPreventDefault") });
    }
};
jQuery.event.special.touchmove = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchmove", handle, { passive: !ns.includes("noPreventDefault") });
    }
};

jQuery(document).ready(function () {
    // jQuery(window).scroll(function(){
    //     if(jQuery(document).scrollTop() >= jQuery(document).height()-jQuery(window).height())
    //         jQuery('#block-strzalka').fadeOut();
    //     else if (!jQuery('#block-strzalka').is(':visible'))
    //         jQuery('#block-strzalka').fadeIn();
    // });
    const url = window.location.pathname;
    let hash = window.location.hash;

    OrphansAndWidows('p');
    OrphansAndWidows('h1');
    OrphansAndWidows('h2');

    jQuery('#nav-icon').off('click').click(function(){
        jQuery(this).toggleClass('open');
        jQuery('#block-theme-main-menu').toggleClass('open');
        jQuery('#block-theme-main-menu > ul').slideToggle(400, 'swing');
        jQuery('#block-theme-main-menu > ul > li').removeClass('open');
    });

    jQuery(window).scroll(function () {
        var fromTop = jQuery(document).scrollTop();
        if (fromTop > 200) {
            jQuery('header').addClass('scroll');
        } else {
            jQuery('header').removeClass('scroll');
        }
    });

    var filter;

    jQuery('.menu .filter').click(function () {
        // if (jQuery(this).data('filter') != 'all') {
        filter = jQuery(this).data('filter');

        // jQuery('.support-item').parent().fadeOut();
        jQuery('.menu .dishes').fadeOut().promise().done(function () {
            // AOS.refresh();
            jQuery('.menu .dishes').filter('[data-filter="' + filter + '"]').fadeIn();
            // window.location.hash = '#'+filter;
        });
        jQuery('.menu .active').removeClass('active');
        jQuery(this).addClass('active');
    });

    // var iOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
    if (iOS()) {
        // alert('ios');
        jQuery('.box.image, .parallax-image').addClass('iOS');
    } else {
        // alert('and');
        // alert(navigator.platform);
    }

    // REALIZATION

    if(jQuery('.realizations').length > 0) {
        jQuery('.realizations .links span[data-url="'+url+'"]').addClass('active');
        var active = jQuery('.realizations .links .active').index(),
            length = jQuery('.realizations .links span').length,
            next,
            prev,
            nextHTML = jQuery('.realizations .pager .next').html(),
            prevHTML = jQuery('.realizations .pager .prev').html();

        next = jQuery('.realizations .links span').eq(active + 1).data('url');
        prev = jQuery('.realizations .links span').eq(active - 1).data('url');
        if (active == '0') {
            prev = jQuery('.realizations .links span').eq(length - 1).data('url');
        } else if (active == length - 1) {
            next = jQuery('.realizations .links span').eq(0).data('url');
        }

        jQuery('.realizations .pager .prev').attr('href', prev);
        jQuery('.realizations .pager .next').attr('href', next);

        if (jQuery(window).width() < 1230) {
            jQuery('.realizations .pager .prev').html(jQuery('.realizations .pager .prev').data('mobile'));
            jQuery('.realizations .pager .next').html(jQuery('.realizations .pager .next').data('mobile'));
        } else {
            jQuery('.realizations .pager .prev').html(prevHTML);
            jQuery('.realizations .pager .next').html(nextHTML);
        }
    }
});

jQuery(window).on('load', function () {
    if (jQuery('.home .slider--top .slide').length > 1) {
        jQuery('.home .slider--top').slick({
            arrows: true,
            dots: true,
            autoplay: true,
            fade: true,
            nextArrow: '<img class="next" src="/themes/custom/theme/images/arrow-right.svg" />',
            prevArrow: '<img class="prev" src="/themes/custom/theme/images/arrow-right.svg" />',
        });
    }

    if (jQuery('.home .slider--bottom .slide').length > 1) {
        jQuery('.home .slider--bottom').slick({
            arrows: true,
            dots: true,
            autoplay: true,
            fade: true,
            nextArrow: '<img class="next" src="/themes/custom/theme/images/arrow-right.svg" />',
            prevArrow: '<img class="prev" src="/themes/custom/theme/images/arrow-right.svg" />',
        });
    }

    jQuery('.page .slider').slick({
        arrows: true,
        dots: true,
        autoplay: true,
        fade: true,
        nextArrow: '<img class="next" src="/themes/custom/theme/images/arrow-right.svg" />',
        prevArrow: '<img class="prev" src="/themes/custom/theme/images/arrow-right.svg" />',
    });
});

function OrphansAndWidows(container) {
    var content = jQuery(container);
    for (var i = 0; i < content.length; i++) {
        var tekst = content[i].innerHTML;
        //tekst = tekst.replace(/(\s)([^<][\S]{2})[\s]+/g,"$1$2&nbsp;"); //trzyznakowe
        tekst = tekst.replace(/(\s)([^<][\S]{1})[\s]+/g, "$1$2&nbsp;"); //dwuznakowe
        tekst = tekst.replace(/(\s)([\S])[\s]+/g, "$1$2&nbsp;"); //jednoznakowe
        content[i].innerHTML = tekst;
    }

}

function iOS() {

    var iDevices = [
        'iPad Simulator',
        'iPhone Simulator',
        'iPod Simulator',
        'iPad',
        'iPhone',
        'iPod',
        'MacIntel'
    ];

    if (!!navigator.platform) {
        while (iDevices.length) {
            if (navigator.platform === iDevices.pop()){ return true; }
        }
    }

    return false;
}